package gov.va.med.mhv.common.api.pagination;

import java.util.Iterator;
import java.util.List;
import java.util.function.Function;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;

import com.fasterxml.jackson.annotation.JsonIgnore;

public class PageableResponse<T> implements Page<T> {
	
	private int number;
	
	private int size;
	
	private List<T> content = null;
	
	@JsonIgnore
	private Sort sort;
	
	private boolean isFirst;
	
	private boolean isLast;

	private boolean hasNext;

	private boolean hasPrevious;
	
	private int totalPages;
	
	private long totalElements;
	
	public PageableResponse() {
		
	}
	
	public PageableResponse(Page<T> page) {
		this.number = page.getNumber();
		this.size = page.getSize();
		this.content = page.getContent();
		this.sort = page.getSort();
		this.isFirst = page.isFirst();
		this.isLast = page.isLast();
		this.hasNext = page.hasNext();
		this.hasPrevious = page.hasPrevious();
		this.totalPages = page.getTotalPages();
		this.totalElements = page.getTotalElements();
	}

	@Override
	public int getNumber() {
		return this.number;
	}
	
	public void setNumber(int number) {
		this.number = number;
	}

	@Override
	public int getSize() {
		return this.size;
	}
	
	public void setSize(int size) {
		this.size = size;
	}

	@JsonIgnore
	@Override
	public int getNumberOfElements() {
		return (this.hasContent()) ? this.getContent().size() : 0;
	}

	@Override
	public List<T> getContent() {
		return this.content;
	}
	
	public void setContent(List<T> content) {
		this.content = content;
	}

	@Override
	public boolean hasContent() {
		return (this.content != null && this.content.size() > 0);
	}

	@Override
	public Sort getSort() {
		return this.sort;
	}
	
	public void setSort(Sort sort) {
		this.sort = sort;
	}
	
	@Override
	public boolean isFirst() {
		return this.isFirst;
	}
	
	public void setFirst(boolean isFirst) {
		this.isFirst = isFirst;
	}

	@Override
	public boolean isLast() {
		return this.isLast;
	}
	
	public void setLast(boolean isLast) {
		this.isLast = isLast;
	}

	@Override
	public boolean hasNext() {
		return this.hasNext;
	}
	
	public void setHasNext(boolean hasNext) {
		this.hasNext = hasNext;
	}

	@Override
	public boolean hasPrevious() {
		return this.hasPrevious;
	}
	
	public void setHasPrevious(boolean hasPrevious) {
		this.hasPrevious = hasPrevious;
	}

	@Override
	public Pageable nextPageable() {
		Pageable nextPageable = null;
		if(hasNext()) {
			nextPageable = PageRequest.of(this.number+1, this.size, this.sort);
		}
		return nextPageable;
	}
	
	@Override
	public Pageable previousPageable() {
		Pageable prevPageable = null;
		if(hasPrevious()) {
			prevPageable = PageRequest.of(this.number+1, this.size, this.sort);
		}
		return prevPageable;
	}

	@Override
	public Iterator<T> iterator() {
		return this.content.iterator();
	}

	@Override
	public int getTotalPages() {
		return this.totalPages;
	}

	@Override
	public long getTotalElements() {
		return this.totalElements;
	}
	
	

	@Override
	public <U> Page<U> map(Function<? super T, ? extends U> arg0) {
		throw new UnsupportedOperationException("The map method is not intended for use.");
	}
	
}
